string GetDescription()
{
	return "This is a simple ornamentation that passes the notes unaltered.";
}

double GetEventLen(UniquePart @up, int i)
{
	return 	(up.GetEventEnd(i).m_Bar - up.GetEventStart(i).m_Bar) * up.GetMetrum() + ( up.GetEventEnd(i).m_Pos - up.GetEventStart(i).m_Pos);
}

void Ornament(UniquePart @up, Part @p)
{
	int off_mode = RndInt(0,1);
	if (off_mode == 0) off_mode = -1;
	
	int last_off = RndInt(0,1);
	
	for (int i = 0; i < up.GetEvents(); i++)
	{
		Time t1 = up.GetEventStart(i);
		Time t2 = up.GetEventEnd(i);
		
		bool tril = false;
		
		if (RndInt(0,2) != 0 && GetEventLen(up, i) > 1.4)
		{
			double len = 0.25;
			
			p.AddEvent(t1, CreateTime(t1.m_Bar, t1.m_Pos+len), p.ComputePitch(up.GetEventPitch(i)));	
			p.AddEvent(CreateTime(t1.m_Bar, t1.m_Pos+len*2), CreateTime(t1.m_Bar, t1.m_Pos+len*3), p.ComputePitch(up.GetEventPitch(i)));	
			
			if (RndInt(0,1) == 0)
			{
				p.AddEvent(CreateTime(t1.m_Bar, t1.m_Pos+len), CreateTime(t1.m_Bar, t1.m_Pos+len*2), p.ComputePitch(up.GetEventPitch(i))-1);		
				p.AddEvent(CreateTime(t1.m_Bar, t1.m_Pos+len*3), CreateTime(t1.m_Bar, t1.m_Pos+len*4), p.ComputePitch(up.GetEventPitch(i)+1));	
			}
			else
			{
				p.AddEvent(CreateTime(t1.m_Bar, t1.m_Pos+len), CreateTime(t1.m_Bar, t1.m_Pos+len*2), p.ComputePitch(up.GetEventPitch(i)+1));	
				p.AddEvent(CreateTime(t1.m_Bar, t1.m_Pos+len*3), CreateTime(t1.m_Bar, t1.m_Pos+len*4), p.ComputePitch(up.GetEventPitch(i))-1);		
			}
			
			tril = true;
			
			t1.m_Pos += len*4;
			
		}
		else if (GetEventLen(up, i) > 0.9 && RndInt(0,2) != 0)
		{
			double len = 0.25;
			
			p.AddEvent(t1, CreateTime(t1.m_Bar, t1.m_Pos+len), p.ComputePitch(up.GetEventPitch(i)));	
			if (RndInt(0,1) == 0) p.AddEvent(CreateTime(t1.m_Bar, t1.m_Pos+len), CreateTime(t1.m_Bar, t1.m_Pos+len*2), p.ComputePitch(up.GetEventPitch(i))-1);	
			else p.AddEvent(CreateTime(t1.m_Bar, t1.m_Pos+len), CreateTime(t1.m_Bar, t1.m_Pos+len*2), p.ComputePitch(up.GetEventPitch(i)+1));	
			t1.m_Pos += len*2;
			
			tril = true;
		}
		
		double l1 = -100;
		if (i > 0 ) l1 = up.GetEventEnd(i-1).m_Bar * up.GetMetrum() + up.GetEventEnd(i-1).m_Pos;
		double l2 = up.GetEventStart(i).m_Bar * up.GetMetrum() + up.GetEventStart(i).m_Pos;
		
		if (!tril && l1 < l2-0.1 && RndInt(0,1) == 0)
		{
			double len = 0.1;
			if (RndInt(0,1) == 0) p.AddEvent(CreateTime(t1.m_Bar, t1.m_Pos - len) ,t1, p.ComputePitch(up.GetEventPitch(i))-1);	
			else p.AddEvent(CreateTime(t1.m_Bar, t1.m_Pos - len) ,t1, p.ComputePitch(up.GetEventPitch(i)+1));	
			
			tril = true;
		}
		
		int off_diat = 0;
		int off_chrom = 0;
		if (i > 0 && i < up.GetEvents()-1 && !tril && last_off == 0)
		{
			if (up.GetEventPitch(i+off_mode) == up.GetEventPitch(i))
			{
				off_diat = 1;
				last_off = 1;
			}
			else last_off = 0;
		}
		else last_off = 0;
		
		p.AddEvent(t1,t2, p.ComputePitch(up.GetEventPitch(i)+off_diat)+off_chrom);
		
		
	
		
	}
}